/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.model.output;

import com.badlogic.gdx.math.GridPoint2;
import java.util.HashSet;
import java.util.Set;
import technology.rocketjump.undermount.mapgen.generators.SequentialIdGenerator;
import technology.rocketjump.undermount.mapgen.model.output.GameMapTile;
import technology.rocketjump.undermount.mapgen.model.output.TileSubType;

public class MapSubRegion {
    private final TileSubType subRegionType;
    private final long subRegionId;
    private Set<GameMapTile> tiles = new HashSet<GameMapTile>();
    private int minX = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxY = Integer.MIN_VALUE;

    public MapSubRegion(TileSubType subRegionType) {
        this.subRegionId = SequentialIdGenerator.nextId();
        this.subRegionType = subRegionType;
    }

    public void add(GameMapTile tile) {
        if (!this.contains(tile)) {
            tile.setSubRegion(this);
            if (tile.getPosition().x < this.minX) {
                this.minX = tile.getPosition().x;
            }
            if (tile.getPosition().x > this.maxX) {
                this.maxX = tile.getPosition().x;
            }
            if (tile.getPosition().y < this.minY) {
                this.minY = tile.getPosition().y;
            }
            if (tile.getPosition().y > this.maxY) {
                this.maxY = tile.getPosition().y;
            }
        }
        this.tiles.add(tile);
    }

    public void remove(GameMapTile tile) {
        if (this.contains(tile)) {
            this.tiles.remove(tile);
            tile.setSubRegion(null);
        }
    }

    public boolean contains(GameMapTile tile) {
        return this.tiles.contains(tile);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int size() {
        return this.tiles.size();
    }

    public TileSubType getSubRegionType() {
        return this.subRegionType;
    }

    public long getSubRegionId() {
        return this.subRegionId;
    }

    public GridPoint2 getMiddle() {
        return new GridPoint2((this.maxX - this.minX) / 2 + this.minX, (this.maxY - this.minY) / 2 + this.minY);
    }
}

